import javax.swing.*;
import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.net.*;

public class 
ChatClient extends JFrame implements ActionListener
{
  protected DefaultListModel<String> dlm;
  protected JList lstNicks;
  protected JTextArea taMain;
  protected JTextField tfCommand;
  protected JButton btnConnect;
  protected JButton btnDisconnect;
  protected JButton btnExit;

  protected boolean connected;
  protected Socket socket;
  protected BufferedReader socketIn;
  protected DataOutputStream socketOut;
  protected ChatClientThread clientThread;
  
  public ChatClient()
  {
    super("ChatClient");
    setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
    addWindowListener(new WindowAdapter (){
        public void windowClosing(WindowEvent e){ 
          exitClicked();
        }
      }
    );
    initLayout();
    setVisible(true);
  }
  public void initLayout()
  {
    setSize(650, 520);
    setResizable(false);
    setLayout(null);
    
    taMain = new JTextArea();
    taMain.setEditable(false);
    JScrollPane panelLeft = new JScrollPane(taMain);
    panelLeft.setBounds(10, 20, 480, 360);
    add(panelLeft);

    dlm = new DefaultListModel<String>();
    lstNicks = new JList<String>(dlm);
    JScrollPane panelRight = new JScrollPane(lstNicks);
    panelRight.setBounds(500, 20, 130, 360);
    add(panelRight);
    
    JPanel panelBottom1 = new JPanel();
    panelBottom1.setLayout(new BorderLayout());
    panelBottom1.setBounds(10, 395, 620, 25);
    add(panelBottom1);

    JPanel panelBottom2 = new JPanel();
    panelBottom2.setLayout(new GridLayout(1, 3));
    panelBottom2.setBounds(10, 430, 620, 35);
    add(panelBottom2);
    
    tfCommand = new JTextField();
    tfCommand.addKeyListener(new KeyAdapter(){
      public void keyPressed(KeyEvent evt){
        keyPressed(evt.getKeyCode());
      }
    });
    panelBottom1.add(tfCommand);

    btnConnect = new JButton("Pocz");
    btnConnect.setActionCommand("Connect");
    btnConnect.addActionListener(this);
    panelBottom2.add(btnConnect);

    btnDisconnect = new JButton("Rozcz");
    btnDisconnect.setActionCommand("Disconnect");
    btnDisconnect.addActionListener(this);
    panelBottom2.add(btnDisconnect);

    btnExit = new JButton("Wyjd");
    btnExit.setActionCommand("Exit");
    btnExit.addActionListener(this);
    panelBottom2.add(btnExit);

  }
  public static void main(String args[]){
    SwingUtilities.invokeLater(new Runnable() {
      public void run() {
        new ChatClient();
      }
    });
  }
  public void actionPerformed(ActionEvent evt)
  {
    String tmp = evt.getActionCommand();
    if (tmp.equals("Exit")){
      exitClicked();
    }
    else if (tmp.equals("Disconnect")){
      disconnectClicked();
    }
    else if (tmp.equals("Connect")){
      connectClicked();
    }
  }
  public void connectClicked()
  {
    if(connected){
      insertText("Najpierw zakocz biece poczenie!");
      return;
    }
    connect("localhost", 6666);
  }
  public void connect(String host, int port)
  {
    connected = false;
    insertText("czenie z hostem " + host + "\n");
    try{
      socket = new Socket(host, port);
    }
    catch(IOException e){
      insertText("Bd gniazda: " + e + "\n");
      return;
    }
    insertText("Zakoczona inicjalizacja gniazda...\n");
    try{
      socketOut = new DataOutputStream(socket.getOutputStream());
      socketIn = new BufferedReader(
        new InputStreamReader(socket.getInputStream()));
    }
    catch(IOException e){
      insertText("Bd przy tworzeniu strumieni: " + e + "\n");
      return;
    }
    clientThread = new ChatClientThread(this, socket, socketIn);
    clientThread.start();
    insertText("Poczono z serwerem.\n");
    connected = true;
  }
  public void disconnectClicked()
  {
    if (!connected){
      insertText("Brak poczenia!\n");
      return;
    }
    clientThread.interrupt();
    connected = false;
  }
  public void keyPressed(int keyCode)
  {
    if (keyCode != KeyEvent.VK_ENTER){
      return;
    }
    if (!connected){
      insertText("Najpierw nawi poczenie!\n");
      return;
    }
    String line = tfCommand.getText();
    if (line.equals("")) return;
    tfCommand.setText("");
    try{
      socketOut.writeBytes(line + "\n");
      socketOut.flush();
    }
    catch(IOException e){
      insertText("Bd przy wysyaniu danych: " + e + "\n");
    }
  }
  public void clientThreadStopped()
  {
    insertText("Rozczono!\n");
    connected = false;
    try{
      if(!socket.isClosed())
        socket.close();
    }
    catch(IOException e){}
  }
  public void insertText(final String line)
  {
    if(SwingUtilities.isEventDispatchThread()){
      taMain.insert(line, 0);
    }
    else{
      SwingUtilities.invokeLater(
        new Runnable(){
          public void run(){
            taMain.insert(line, 0);
          } 
        }
      );
    }
  }
  public void exitClicked()
  {
    if(connected)
      clientThread.interrupt();
    dispose();
  }
}
